/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MomentumModifier
extends Modifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "momentum.mining_speed");

    @Override
    public int getPriority() {
        return 75;
    }

    private static float getBonus(LivingEntity living, int level) {
        int effectLevel = ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).getLevel(living) + 1;
        return (float)(level * effectLevel) / 128.0f;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + MomentumModifier.getBonus(event.getEntityLiving(), level)));
        }
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            LivingEntity living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).getLevel(living) + 1);
            int duration = (int)(10.0f / tool.getStats().get(ToolStats.MINING_SPEED).floatValue() * 1.5f * 20.0f);
            ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).apply(living, duration, effectLevel, true);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            float bonus = player != null && key == TooltipKey.SHIFT ? MomentumModifier.getBonus((LivingEntity)player, level) : (float)level * 0.25f;
            this.addPercentTooltip(MINING_SPEED, bonus, tooltip);
        }
    }
}

